/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.dinardap.servicio;

import ec.gob.dinardap.models.Persona;
import ec.gob.dinardap.utils.DateUtilities;
import ec.gob.prueba.ws.DINARDAPService.Columna;
import ec.gob.prueba.ws.DINARDAPService.Consultar;
import ec.gob.prueba.ws.DINARDAPService.ConsultarFaultException;
import ec.gob.prueba.ws.DINARDAPService.ConsultarResponse;
import ec.gob.prueba.ws.DINARDAPService.Entidad;
import ec.gob.prueba.ws.DINARDAPService.Fila;
import ec.gob.prueba.ws.DINARDAPService.Interoperador;
import ec.gob.prueba.ws.DINARDAPService.Parametro;
import ec.gob.prueba.ws.DINARDAPService.Parametros;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public class ServicioDinardap {
    public static Persona getDatosDINARDAP(String identificacion) {
        Persona persona = new Persona();
        try {
            JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
            factory.setServiceClass(Interoperador.class);
            factory.setAddress("https://interoperabilidad.dinardap.gob.ec/interoperador-v2?wsdl");
            factory.setUsername("InTerGadMs");
            factory.setPassword("X2+q-9Pth&3wBV");
            Interoperador port = (Interoperador)factory.create();
            Client client = ClientProxy.getClient((Object)port);
            if (client != null) {
                HTTPConduit conduit = (HTTPConduit)client.getConduit();
                HTTPClientPolicy policy = new HTTPClientPolicy();
                policy.setAllowChunking(false);
                conduit.setClient(policy);
            }
            Parametro paramCodigoPaquete = new Parametro();
            if (identificacion.length() == 10) {
                paramCodigoPaquete.setNombre("codigoPaquete");
                paramCodigoPaquete.setValor("3901");
                persona.setEsPersona(true);
            }
            if (identificacion.length() == 13) {
                paramCodigoPaquete.setNombre("codigoPaquete");
                paramCodigoPaquete.setValor("3909");
                persona.setEsPersona(false);
            }
            Parametro paramIdent = new Parametro();
            paramIdent.setNombre("identificacion");
            paramIdent.setValor(identificacion);
            Parametros parametros = new Parametros();
            parametros.getParametro().add(paramCodigoPaquete);
            parametros.getParametro().add(paramIdent);
            Consultar consultar = new Consultar();
            consultar.setParametros(parametros);
            ConsultarResponse response = port.consultar(consultar);
            List<Entidad> entidades = response.getPaquete().getEntidades().getEntidad();
            for (Entidad entidad : entidades) {
                for (Fila fila : entidad.getFilas().getFila()) {
                    for (Columna columna : fila.getColumnas().getColumna()) {
                        if (columna.getCampo().equals("nombre")) {
                            persona.setNombres(columna.getValor());
                        }
                        if (columna.getCampo().equals("fechaNacimiento")) {
                            try {
                                persona.setFechaNacimiento(DateUtilities.convertDate(columna.getValor(), "dd/MM/yyyy"));
                            }
                            catch (ParseException ex) {
                                Logger.getLogger(ServicioDinardap.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        if (columna.getCampo().equals("fechaDefuncion") && !columna.getValor().isEmpty()) {
                            try {
                                persona.setFechaDefuncion(DateUtilities.convertDate(columna.getValor(), "dd/MM/yyyy"));
                            }
                            catch (ParseException ex) {
                                Logger.getLogger(ServicioDinardap.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        if (columna.getCampo().equals("fechaExpedicion")) {
                            try {
                                persona.setFechaExpedicionCedula(DateUtilities.convertDate(columna.getValor(), "dd/MM/yyyy"));
                            }
                            catch (ParseException ex) {
                                Logger.getLogger(ServicioDinardap.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        if (identificacion.length() == 13) {
                            if (columna.getCampo().equals("emailMedCon") && !columna.getValor().isEmpty()) {
                                persona.setCorreoElectronico(columna.getValor());
                            }
                            if (columna.getCampo().equals("telefonoCelularMedCon") && !columna.getValor().isEmpty()) {
                                persona.setTelefono(columna.getValor());
                            }
                        }
                        if (!columna.getCampo().equals("estadoCivil")) continue;
                        persona.setEstadoCivil(columna.getValor());
                    }
                }
            }
            if (!entidades.isEmpty()) {
                persona.setExistePersona(Boolean.TRUE);
            } else {
                persona.setExistePersona(Boolean.FALSE);
            }
        }
        catch (ConsultarFaultException ex) {
            ex.printStackTrace(System.out);
            persona.setErrorConsumo(Boolean.TRUE);
            System.out.println(persona.getErrorConsumo() + " Error de consumo de datos seguro");
        }
        return persona;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServicioDinardap)) {
            return false;
        }
        ServicioDinardap other = (ServicioDinardap)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServicioDinardap;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ServicioDinardap()";
    }
}

