/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.dinardap.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtilities {
    public static final int DAY_MONT_YEAR = 1;
    public static final int DAY_YEAR_MONT = 2;
    public static final int YEAR_MONT_DAY = 3;
    public static final int YEAR_DAY_MONT = 4;
    public static final String DATE_PATTERN = "dd/MM/yyyy";
    public static String[] months = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
    public static String[] days = new String[]{"Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"};

    private static String getDate(String delimiter, int format, boolean dateInLetter, boolean showHour, boolean showSeconds) {
        return DateUtilities.getDate(new Date(), delimiter, format, dateInLetter, showHour, showSeconds);
    }

    private static String getDate(Date date, String delimiter, int format, boolean dateInLetter, boolean showHour, boolean showSeconds) {
        if (date == null) {
            return "";
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.getTime());
        String strDate = "";
        int day = c.get(5);
        int dayW = c.get(7) - 1;
        int year = c.get(1);
        int month = c.get(2);
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        switch (format) {
            case 1: {
                if (dateInLetter) {
                    strDate = strDate + days[dayW] + " " + day + " de " + months[month] + " de " + year;
                    if (showSeconds) {
                        strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":" + (second < 10 ? "0" + second : Integer.valueOf(second));
                        break;
                    }
                    if (!showHour) break;
                    strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
                    break;
                }
                strDate = strDate + (day < 10 ? "0" + day : Integer.valueOf(day)) + delimiter + (month < 9 ? "0" + (month + 1) : Integer.valueOf(month + 1)) + delimiter + year;
                if (showSeconds) {
                    strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":" + (second < 10 ? "0" + second : Integer.valueOf(second));
                    break;
                }
                if (!showHour) break;
                strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
                break;
            }
            case 2: {
                if (dateInLetter) {
                    strDate = strDate + days[dayW] + " " + day + " de " + months[month] + " de " + year;
                    if (showSeconds) {
                        strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":" + (second < 10 ? "0" + second : Integer.valueOf(second));
                        break;
                    }
                    if (!showHour) break;
                    strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
                    break;
                }
                strDate = strDate + (day < 10 ? "0" + day : Integer.valueOf(day)) + delimiter + year + delimiter + (month < 9 ? "0" + (month + 1) : Integer.valueOf(month + 1));
                if (showSeconds) {
                    strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":" + (second < 10 ? "0" + second : Integer.valueOf(second));
                    break;
                }
                if (!showHour) break;
                strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
                break;
            }
            case 4: {
                if (dateInLetter) {
                    strDate = strDate + days[dayW] + " " + day + " de " + months[month] + " de " + year;
                    if (showSeconds) {
                        strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":" + (second < 10 ? "0" + second : Integer.valueOf(second));
                        break;
                    }
                    if (!showHour) break;
                    strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
                    break;
                }
                strDate = strDate + year + delimiter + (day < 10 ? "0" + day : Integer.valueOf(day)) + delimiter + (month < 9 ? "0" + (month + 1) : Integer.valueOf(month + 1));
                if (showSeconds) {
                    strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":" + (second < 10 ? "0" + second : Integer.valueOf(second));
                    break;
                }
                if (!showHour) break;
                strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
                break;
            }
            case 3: {
                if (dateInLetter) {
                    strDate = strDate + days[dayW] + " " + day + " de " + months[month] + " de " + year;
                    if (showSeconds) {
                        strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":" + (second < 10 ? "0" + second : Integer.valueOf(second));
                        break;
                    }
                    if (!showHour) break;
                    strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
                    break;
                }
                strDate = strDate + year + delimiter + (month < 9 ? "0" + (month + 1) : Integer.valueOf(month + 1)) + delimiter + (day < 10 ? "0" + day : Integer.valueOf(day));
                if (showSeconds) {
                    strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":" + (second < 10 ? "0" + second : Integer.valueOf(second));
                    break;
                }
                if (!showHour) break;
                strDate = strDate + (hour < 10 ? "  0" + hour : "  " + hour) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
            }
        }
        return strDate;
    }

    public static synchronized String getHour(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.getTime());
        int min = c.get(12);
        int hour = c.get(11);
        String s = "" + (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (min < 10 ? "0" + min : Integer.valueOf(min));
        return s;
    }

    public static synchronized String getDate() {
        return DateUtilities.getDate("/", 1, false, false, false);
    }

    public static synchronized String getDate(Date date) {
        return DateUtilities.getDate(date, "/", 1, false, false, false);
    }

    public static synchronized String getDateHour() {
        return DateUtilities.getDate("/", 1, false, true, false);
    }

    public static synchronized String getDateHourSecond() {
        return DateUtilities.getDate("/", 1, false, true, true);
    }

    public static synchronized String getDate(String delimiter) {
        return DateUtilities.getDate(delimiter, 1, false, false, false);
    }

    public static synchronized String getDateHour(String delimiter) {
        return DateUtilities.getDate(delimiter, 1, false, true, false);
    }

    public static synchronized String getDateHourSecond(String delimiter) {
        return DateUtilities.getDate(delimiter, 1, false, true, true);
    }

    public static synchronized String getDate(int format) {
        return DateUtilities.getDate("/", format, false, false, false);
    }

    public static synchronized String getDateHour(Date date, int format) {
        return DateUtilities.getDate(date, "/", format, true, true, false);
    }

    public static synchronized String getDateHour(int format) {
        return DateUtilities.getDate("/", format, false, true, false);
    }

    public static synchronized String getDateHourSecond(int format) {
        return DateUtilities.getDate("/", format, false, true, true);
    }

    public static synchronized String getDate(int format, String delimiter) {
        return DateUtilities.getDate(delimiter, format, false, false, false);
    }

    public static synchronized String getDateHour(int format, String delimiter) {
        return DateUtilities.getDate(delimiter, format, false, true, false);
    }

    public static synchronized String getDateHourSecond(int format, String delimiter) {
        return DateUtilities.getDate(delimiter, format, false, true, true);
    }

    public static synchronized String getDate(int format, boolean dateInLetter) {
        return DateUtilities.getDate("/", format, dateInLetter, false, false);
    }

    public static synchronized String getDate(Date date, int format, boolean dateInLetter) {
        return DateUtilities.getDate(date, "/", format, dateInLetter, false, false);
    }

    public static synchronized String getDate(Date date, int format, String delimiter) {
        return DateUtilities.getDate(date, delimiter, format, false, false, false);
    }

    public static synchronized String getDateHour(int format, boolean dateInLetter) {
        return DateUtilities.getDate("/", format, dateInLetter, true, false);
    }

    public static synchronized String getDateHourSecond(int format, boolean dateInLetter) {
        return DateUtilities.getDate("/", format, dateInLetter, true, true);
    }

    public static synchronized String getDateHourSecond(Date date, int format, boolean dateInLetter) {
        return DateUtilities.getDate(date, "/", format, dateInLetter, true, true);
    }

    public static synchronized String getDate(int format, boolean dateInLetter, String delimiter) {
        return DateUtilities.getDate(delimiter, format, dateInLetter, false, false);
    }

    public static synchronized String getDateHour(int format, boolean dateInLetter, String delimiter) {
        return DateUtilities.getDate(delimiter, format, dateInLetter, true, false);
    }

    public static synchronized String getDateHourSecond(int format, boolean dateInLetter, String delimiter) {
        return DateUtilities.getDate(delimiter, format, dateInLetter, true, true);
    }

    public static int compareYear(Date f1, Date f2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(f1);
        c2.setTime(f2);
        return c1.get(1) - c2.get(1);
    }

    public static Date substractDate(Date one, Date second) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(one);
        c2.setTime(second);
        c1.setTimeInMillis(c1.getTimeInMillis() - c2.getTimeInMillis());
        return c1.getTime();
    }

    public static synchronized Date convertDate(String strFecha, String strPatron) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(strPatron);
        return dateFormat.parse(strFecha);
    }

    public static synchronized Date addDays(Date fecha, int dias) {
        Calendar c = Calendar.getInstance();
        c.setTime(fecha);
        c.add(6, dias);
        return c.getTime();
    }

    public static synchronized Date addMonths(Date fecha, int months) {
        Calendar c = Calendar.getInstance();
        c.setTime(fecha);
        c.add(2, months);
        return c.getTime();
    }

    public static synchronized Date addHours(Date fecha, int hours) {
        Calendar c = Calendar.getInstance();
        c.setTime(fecha);
        c.add(11, hours);
        return c.getTime();
    }

    public static synchronized Date addMinutes(Date fecha, int minutes) {
        Calendar c = Calendar.getInstance();
        c.setTime(fecha);
        c.add(12, minutes);
        return c.getTime();
    }

    public static synchronized long compareHours(Date one, Date second) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = (Calendar)c1.clone();
        Calendar aux = Calendar.getInstance();
        aux.setTime(one);
        c1.set(11, aux.get(11));
        c1.set(12, aux.get(12));
        c1.set(13, 0);
        c1.set(14, 0);
        aux.setTime(second);
        c2.set(11, aux.get(11));
        c2.set(12, aux.get(12));
        c2.set(13, 0);
        c2.set(14, 0);
        return (c1.getTimeInMillis() - c2.getTimeInMillis()) / 60000L;
    }

    public static Date truncateDate(Date fecha, int value) {
        if (fecha != null) {
            Calendar fechaTruncada = Calendar.getInstance();
            fechaTruncada.setTimeInMillis(fecha.getTime());
            fechaTruncada.set(11, value);
            fechaTruncada.set(12, value);
            fechaTruncada.set(13, value);
            fechaTruncada.set(14, value);
            return fechaTruncada.getTime();
        }
        return null;
    }

    public static Date truncateHour(Date fecha, int value) {
        if (fecha != null) {
            Calendar fechaTruncada = Calendar.getInstance();
            fechaTruncada.setTimeInMillis(fecha.getTime());
            fechaTruncada.set(11, value);
            fechaTruncada.set(12, 0);
            fechaTruncada.set(13, 0);
            fechaTruncada.set(14, 0);
            return fechaTruncada.getTime();
        }
        return null;
    }

    public static int getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static int getMinute(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(12);
    }

    public static int getSecond(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(13);
    }

    public static Date truncateToHour(Date date) {
        int minutes = DateUtilities.getMinute(date);
        if (minutes < 30 & minutes > 0) {
            date = DateUtilities.addMinutes(date, 30 - minutes);
        } else if (minutes > 30) {
            date = DateUtilities.addMinutes(date, 60 - minutes);
        }
        return date;
    }

    public static int getMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2) + 1;
    }

    public static String getMonthNew(Date date) {
        if (null == date) {
            return "0";
        }
        String formato = "MM";
        SimpleDateFormat dateFormat = new SimpleDateFormat(formato);
        return String.valueOf(dateFormat.format(date));
    }

    public static String getDayNew(Date date) {
        if (null == date) {
            return "0";
        }
        String formato = "dd";
        SimpleDateFormat dateFormat = new SimpleDateFormat(formato);
        return String.valueOf(dateFormat.format(date));
    }

    public static int getYearNew(Date date) {
        if (null == date) {
            return 0;
        }
        String formato = "yyyy";
        SimpleDateFormat dateFormat = new SimpleDateFormat(formato);
        return Integer.parseInt(dateFormat.format(date));
    }

    public static int getDayOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(6);
    }

    public static int getDayOfMoth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int calcularMesesDiferencias(Date fechaInicio, Date fechaFin) {
        try {
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.setTime(fechaInicio);
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(fechaFin);
            int startMes = startCalendar.get(1) * 12 + startCalendar.get(2);
            int endMes = endCalendar.get(1) * 12 + endCalendar.get(2);
            int diffMonth = endMes - startMes;
            return diffMonth;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getMonthLeters(Date fecha) {
        int m = DateUtilities.getMonth(fecha);
        String mes = "";
        switch (m) {
            case 1: {
                mes = "Enero";
                break;
            }
            case 2: {
                mes = "Febrero";
                break;
            }
            case 3: {
                mes = "Marzo";
                break;
            }
            case 4: {
                mes = "Abril";
                break;
            }
            case 5: {
                mes = "Mayo";
                break;
            }
            case 6: {
                mes = "Junio";
                break;
            }
            case 7: {
                mes = "Julio";
                break;
            }
            case 8: {
                mes = "Agosto";
                break;
            }
            case 9: {
                mes = "Septiembre";
                break;
            }
            case 10: {
                mes = "Octubre";
                break;
            }
            case 11: {
                mes = "Noviembre";
                break;
            }
            case 12: {
                mes = "Diciembre";
            }
        }
        return mes;
    }
}

