/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.dinardap.utils;

import ec.gob.dinardap.utils.Archivo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;

public class Utils {
    private static final int[] PATTERN = new int[]{2, 1, 2, 1, 2, 1, 2, 1, 2};
    private static final int[] CASO_9 = new int[]{4, 3, 2, 7, 6, 5, 4, 3, 2};
    private static final int[] CASO_6 = new int[]{3, 2, 7, 6, 5, 4, 3, 2};
    private static final String NUMERIC_REGEX = "^[0-9]+$";
    private static final String DECIMAL_REGEX = "^[+]?\\d+([.]\\d+)?$";
    private static final String EMAIL_REGEX = "^[\\w-]+(\\.[\\w-]+)*@[\\w-]+(\\.[\\w-]+)*(\\.[A-Za-z]{1,})$";
    private static final String EMAILV2 = "[\\w\\.-]*[a-zA-Z0-9_]@[\\w\\.-]*[a-zA-Z0-9]\\.[a-zA-Z][a-zA-Z\\.]*[a-zA-Z]";
    public static String base = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static BigDecimal bigdecimalTo2Decimals(BigDecimal inNumber) {
        BigDecimal outNumber;
        String temp = inNumber.toString();
        int indice = temp.indexOf(46);
        if (inNumber.toString().length() - 1 - indice > 2) {
            String tempNew = temp.substring(0, indice + 3);
            outNumber = new BigDecimal(tempNew);
            if (temp.length() - (indice + 1) >= 3 && Integer.parseInt(temp.substring(tempNew.length(), tempNew.length() + 1)) >= 5) {
                outNumber = outNumber.add(new BigDecimal("0.01"));
            }
        } else {
            outNumber = inNumber;
        }
        return outNumber;
    }

    public static List<String> separadorComas(String correos) {
        ArrayList<String> correosResulList = new ArrayList<String>();
        String temp = correos;
        int indice = temp.indexOf(44);
        if (indice > 0) {
            String correoRestante;
            do {
                String correo1 = temp.substring(0, indice);
                correosResulList.add(correo1);
            } while ((indice = (temp = (correoRestante = temp.substring(indice + 1, temp.length()))).indexOf(44)) > 0);
            correosResulList.add(temp);
        } else {
            correosResulList.add(correos);
        }
        return correosResulList;
    }

    public static Boolean isRepetido(Collection<String> val, Object nuevo) {
        boolean i = false;
        for (String x : val) {
            if (!x.equals(nuevo)) continue;
            i = true;
            return i;
        }
        return i;
    }

    public static synchronized boolean validarEmailConExpresion(String email) {
        return Utils.validatePattern(EMAIL_REGEX, email);
    }

    public static synchronized boolean validarEmail(String email) {
        return Utils.validatePattern(EMAILV2, email);
    }

    public static String generarContrase\u00f1a() {
        String contrasena = "";
        int longitud = base.length();
        for (int i = 0; i < 8; ++i) {
            int numero = (int)(Math.random() * (double)longitud);
            String caracter = base.substring(numero, numero + 1);
            contrasena = contrasena + caracter;
        }
        return contrasena;
    }

    public static Long restarFechas(Date fechaActual, Date fechaIngreso) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(fechaActual);
        cal2.setTime(fechaIngreso);
        long milis1 = cal1.getTimeInMillis();
        long milis2 = cal2.getTimeInMillis();
        long diff = milis2 - milis1;
        long diffDays = diff / 86400000L;
        long diffHour = diff / 3600000L;
        if ((diffHour -= diffDays * 24L) > 0L) {
            ++diffDays;
        }
        return diffDays;
    }

    public static synchronized boolean validateCCRuc(String identificacion) {
        if (identificacion == null) {
            return false;
        }
        if (identificacion.trim().isEmpty()) {
            return false;
        }
        if (!Utils.validateNumberPattern(identificacion)) {
            return false;
        }
        if (identificacion.length() != 10 & identificacion.length() != 13) {
            return false;
        }
        int[] coeficientes = null;
        int indiceDigitoVerificador = 9;
        int modulo = 11;
        if (identificacion.length() == 13 && !identificacion.substring(10, 13).equals("001")) {
            return false;
        }
        if (identificacion.charAt(2) == '9') {
            coeficientes = CASO_9;
        } else if (identificacion.charAt(2) == '6') {
            coeficientes = CASO_6;
            indiceDigitoVerificador = 8;
        } else if (identificacion.charAt(2) < '6') {
            coeficientes = PATTERN;
            modulo = 10;
        }
        return Utils.verify(identificacion.toCharArray(), coeficientes, indiceDigitoVerificador, modulo);
    }

    private static boolean verify(char[] array, int[] coeficientes, int indiceDigitoVerificador, int modulo) {
        if (coeficientes == null) {
            return false;
        }
        int sum = 0;
        for (int i = 0; i < coeficientes.length; ++i) {
            int aux = new Integer(String.valueOf(array[i])) * coeficientes[i];
            if (modulo == 10 && aux > 9) {
                aux -= 9;
            }
            sum += aux;
        }
        int mod = sum % modulo;
        mod = mod == 0 ? modulo : mod;
        int res = modulo - mod;
        Integer valorVerificar = null;
        if (array.length == 13) {
            valorVerificar = Integer.valueOf(String.valueOf(array[array.length - (13 - indiceDigitoVerificador)]));
        } else if (array.length == 10) {
            valorVerificar = Integer.valueOf(String.valueOf(array[array.length - (10 - indiceDigitoVerificador)]));
        }
        return res == valorVerificar;
    }

    public static synchronized boolean validateNumberPattern(String valor) {
        return Utils.validatePattern(NUMERIC_REGEX, valor);
    }

    public static synchronized boolean validateDecimalPattern(String valor) {
        return Utils.validatePattern(DECIMAL_REGEX, valor);
    }

    public static synchronized boolean validatePattern(String patron, String valor) {
        Pattern patter = Pattern.compile(patron);
        Matcher matcher = patter.matcher(valor);
        return matcher.matches();
    }

    public static Archivo crearDocumentoArchivo(InputStream is, String ruta, String nombreArchivo, String tipoArchivo) throws IOException {
        File file = new File(ruta);
        try (FileOutputStream out = new FileOutputStream(file);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            is.close();
        }
        Archivo documento = new Archivo();
        documento.setNombre(nombreArchivo);
        documento.setTipo(tipoArchivo);
        documento.setRuta(ruta);
        return documento;
    }

    public static Date sumarRestarDiasFecha(Date fecha, int dias) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fecha);
        calendar.add(6, dias);
        return calendar.getTime();
    }

    public static String pasarUtf(String cadena) throws UnsupportedEncodingException {
        if (cadena != null) {
            byte[] bytes = cadena.getBytes("ISO-8859-1");
            cadena = new String(bytes, "UTF-8");
        }
        return cadena;
    }

    public static String randomNumericString() {
        int i = (int)(Math.random() * 100000.0);
        return String.valueOf(i);
    }

    public static Integer getDateValues(String formatValue, Date value) {
        Integer res = 0;
        SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy");
        f.format(value);
        switch (formatValue.toUpperCase()) {
            case "Y": {
                res = f.getCalendar().get(1);
                break;
            }
            case "M": {
                res = f.getCalendar().get(2);
                break;
            }
            case "D": {
                res = f.getCalendar().get(5);
            }
        }
        return res;
    }

    public static String completarCadenaConCeros(String cadena, Integer longitud) {
        if (cadena == null) {
            return null;
        }
        if (cadena.length() > longitud) {
            return cadena;
        }
        String ceros = "";
        for (int i = 0; i < longitud; ++i) {
            ceros = ceros + "0";
        }
        int tamanio = cadena.length();
        ceros = ceros.substring(0, longitud - tamanio);
        cadena = ceros + cadena;
        return cadena;
    }

    public static String convertirMesALetra(Integer fechames) {
        String mes;
        switch (fechames) {
            case 1: {
                mes = "ENERO";
                break;
            }
            case 2: {
                mes = "FEBRERO";
                break;
            }
            case 3: {
                mes = "MARZO";
                break;
            }
            case 4: {
                mes = "ABRIL";
                break;
            }
            case 5: {
                mes = "MAYO";
                break;
            }
            case 6: {
                mes = "JUNIO";
                break;
            }
            case 7: {
                mes = "JULIO";
                break;
            }
            case 8: {
                mes = "AGOSTO";
                break;
            }
            case 9: {
                mes = "SEPTIEMBRE";
                break;
            }
            case 10: {
                mes = "OCTUBRE";
                break;
            }
            case 11: {
                mes = "NOVIEMBRE";
                break;
            }
            default: {
                mes = "DICIEMBRE";
            }
        }
        return mes;
    }

    public static String quitarSaltos(String cadena) {
        return cadena.replace("\r", "").replace("\n", "");
    }

    public static boolean isDecimal(String cad) {
        try {
            Double.parseDouble(cad);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty(List<?> l) {
        return l == null || l.isEmpty();
    }

    public static boolean isNotEmpty(List<?> l) {
        return !Utils.isEmpty(l);
    }

    public static String isEmpty(String nombres) {
        if (nombres == null || nombres.trim().isEmpty()) {
            return "";
        }
        return nombres;
    }

    public static <T> T isNull(T value) {
        if (value == null || value.toString().trim().length() < 0) {
            return (T)new BigInteger("-1");
        }
        return value;
    }

    public static Boolean isNumberNull(Number value) {
        if (value == null || value.longValue() < 0L) {
            return true;
        }
        return false;
    }

    public static <T> T get(List<T> values, int idx) {
        if (values.size() > idx) {
            return values.get(idx);
        }
        return null;
    }

    public static <T> T get(Collection<T> values, int idx) {
        if (values.size() > idx) {
            ArrayList<T> result = new ArrayList<T>(values);
            return (T)result.get(idx);
        }
        return null;
    }

    public static String dateFormatPattern(String pattern, Date fechaFin) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(fechaFin);
    }

    public static boolean isNum(String nom) {
        try {
            Long.parseLong(nom);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static Integer getAnio(Date fechaIngreso) {
        Calendar c = Calendar.getInstance();
        c.setTime(fechaIngreso);
        return c.get(1);
    }

    public static Integer getMes(Date fechaIngreso) {
        Calendar c = Calendar.getInstance();
        c.setTime(fechaIngreso);
        return c.get(2);
    }

    public static Integer getDia(Date fechaIngreso) {
        Calendar c = Calendar.getInstance();
        c.setTime(fechaIngreso);
        return c.get(5);
    }

    public static Date getPrimerDiaDelAnio(Integer anio) {
        Calendar fecha = Calendar.getInstance();
        fecha.set(anio, 0, 1, 0, 0, 0);
        return fecha.getTime();
    }

    public static HashMap sortByValues(HashMap map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        LinkedHashMap sortedHashMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedHashMap.put(entry.getKey(), entry.getValue());
        }
        return sortedHashMap;
    }

    public static String encriptaEnMD5(String stringAEncriptar) {
        return DigestUtils.md5Hex((String)stringAEncriptar);
    }

    public static String encriptSHAHex(String dato) {
        System.out.println("/encrriptSHA1 " + DigestUtils.sha512Hex((String)dato));
        return DigestUtils.sha512Hex((String)dato);
    }

    public static int boolean2int(Boolean x) {
        if (x.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public static <T> List<T> verificarRepetidos(List<T> object, List<T> previousValues, List<T> duplicateArray, int compare) {
        for (T next : object) {
            int count = 0;
            for (T t : duplicateArray) {
                if (compare == 0) {
                    if (!next.equals(t)) continue;
                    ++count;
                    continue;
                }
                if (!String.valueOf(next).equalsIgnoreCase(String.valueOf(t))) continue;
                ++count;
            }
            if (count != 0 || previousValues.contains(next)) continue;
            previousValues.add(next);
        }
        return previousValues;
    }

    public static String quitarTildes(String cadena) {
        if (cadena == null) {
            return "";
        }
        cadena = Normalizer.normalize(cadena, Normalizer.Form.NFD);
        cadena = cadena.replaceAll("[^\\p{ASCII}(N\u0303)(n\u0303)(\u00a1)(\u00bf)(\u00b0)(U\u0308)(u\u0308)]", "");
        return cadena;
    }
}

